/**************************************************************************//**
 * @file        system_A9139M0.h
 * @version     V0.00.00
 * $Revision:   0 $
 * $Date:       2017-02-23 $
 * @brief       The header file for system_A9139M0.h
 *
 * @note
 *
 * Copyright (C) 2017 AMICCOM Electronics Corp. All rights reserved.
 *****************************************************************************/
 
#ifndef _SYSTEM_A9139M0_H_
#define _SYSTEM_A9139M0_H_

#include "A9139M0.h"
#include "define.h"

#define XTAL    (12800000UL)            /* Oscillator frequency               */

#define WS_REG_ADRS     0x4001F308
#define SET_WS(ws)      HW32_REG(WS_REG_ADRS)=ws

extern Uint32 SystemCoreClock;        /*!< Processor Clock Frequency            */

/**
 * @brief  Write the data (write_data) to the register of address is reg_addr
 * @param  reg_addr     the address of register
 * @return write_data   the data of write
 */
extern void A9139M0_Reg_Write(uint32_t reg_addr, uint32_t write_data);

/**
 * Initialize the system
 *
 * @param  none
 * @return none
 *
 * @brief  Setup the microcontroller system.
 *         Initialize the System and update the SystemCoreClock variable.
 */
extern void SystemInit ( void );

#endif /* _SYSTEM_A9139M0_H_ */
